import 'package:flutter_riverpod/flutter_riverpod.dart';
import 'package:razinsoft_rider/core/routes/app_routes.dart';
import 'package:razinsoft_rider/data/models/waypoint.dart';
import 'package:razinsoft_rider/data/services/navigation_service.dart';
import 'package:razinsoft_rider/presentation/booking/provider/booking_providers.dart';
import 'package:razinsoft_rider/presentation/booking/provider/order_providers.dart';
import 'package:razinsoft_rider/presentation/booking/provider/pusher_provider.dart';
import 'package:razinsoft_rider/presentation/track_order/provider/track_order_provider.dart';
import '../../booking/provider/route_providers.dart';
import '../../payment_method/provider/provider.dart';
import '../../waypoint/provider/way_point_list_providers.dart';
import '../../waypoint/provider/way_point_map_providers.dart';
import '../provider/chat_provider.dart';
import '../provider/order_in_progress_provider.dart';

void handleOrderStatusUpdate({
  required String status,
  required int? orderId,
  required Ref ref,
  bool fromPusher = false,
  bool? paymentStatus,
}) {
  final orderNotifier = ref.read(orderInProgressNotifier.notifier);
  final mapStateNotifier = ref.read(wayPointMapNotifierProvider.notifier);

  void handlePostPusherActions() {
    ref.read(pusherNotifierProvider.notifier).setupPusherListeners(connectAllChannels: true);
    ref.read(bookingNotifierProvider.notifier).inProgress();
    // ref.read(chatNotifierProvider.notifier);
    if(status == 'pending'){
      ref.read(trackOrderNotifierProvider.notifier).goToLookingForDriver();
    }else{
      ref.read(trackOrderNotifierProvider.notifier).goToInProgress();
    }
    NavigationService.pushNamedAndRemoveUntil(AppRoutes.bookingPage);
  }

  void resetPaymentAndGoToConfirm() {
    ref.read(selectedPayMethodProvider.notifier).reset();
    orderNotifier.goToConfirmPay();
  }

  Future<void> setMarkerPolylines()async{
    final notifier = ref.read(createOrderNotifierProvider.notifier);
    ref.read(createOrderNotifierProvider).whenOrNull(success: (data)async{
      final List<Waypoint> waypoints = notifier.constructWaypoints(data);
      ref.read(wayPointListNotifierProvider.notifier).setWayPointList(waypoints);
      ref.read(routeNotifierProvider.notifier).fetchRoutes();
    });

  }
  switch (status) {
    case 'pending':
      break;

    case 'accepted':

      if(fromPusher){
        ref.read(createOrderNotifierProvider.notifier).orderDetailsForCancelRide(orderId: orderId ?? 0);
        ref.read(trackOrderNotifierProvider.notifier).goToInProgress();
      }else{
        setMarkerPolylines();
        mapStateNotifier.updateForAccepted();
      }
      orderNotifier.goToOrderAccept();
      break;

    case 'go_to_pickup':
      orderNotifier.goToHeadingPickup();

      setMarkerPolylines();
      mapStateNotifier.updateForAccepted();
      break;

    case 'confirm_arrival':
      orderNotifier.goToPickupPoint();
      setMarkerPolylines();
      mapStateNotifier.updateForAccepted();

      break;

    case 'picked_up':
      orderNotifier.goToInsideCarReadyToMove();
      mapStateNotifier.updateForPickedUp();
      break;

    case 'start_ride':
      orderNotifier.goToHeadingToDestination();
      setMarkerPolylines();
      mapStateNotifier.updateForPickedUp();
      break;

    case 'dropped_off':
      ref.read(wayPointMapNotifierProvider.notifier).stopTracking();
      if (fromPusher) {
        orderId != null ? ref.read(createOrderNotifierProvider.notifier).orderDetailsForCancelRide(orderId: orderId) : null;
        resetPaymentAndGoToConfirm();
      } else {

        if (paymentStatus != null && paymentStatus) {
          orderNotifier.gotToFeedback();
          NavigationService.pushNamedAndRemoveUntil(AppRoutes.bookingPage);
        } else {
          resetPaymentAndGoToConfirm();
          NavigationService.pushNamedAndRemoveUntil(AppRoutes.bookingPage);
        }
      }
      break;

    case 'completed':
      if (!fromPusher) {
        NavigationService.pushNamedAndRemoveUntil(AppRoutes.dashboard);
      }
      break;
  }

  if (!fromPusher && status != 'completed') {
    handlePostPusherActions();
  }
}
